/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.UDFCommentTextFigure;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;

public class LogoDrawingUDF
extends LogoDrawing {
    private transient EditUDFFigure fEditUDFFigure = null;
    private transient UDFCommentTextFigure fUDFCommentTextFigure = null;

    public LogoDrawingUDF() {
    }

    public LogoDrawingUDF(boolean initMacroFrame) {
        if (initMacroFrame) {
            this.addMacroFrame();
        }
    }

    public FigureEnumeration figures() {
        Vector<AbstractFigure> allFigures = new Vector<AbstractFigure>();
        allFigures.addAll(this.getFigures());
        if (this.fEditUDFFigure != null) {
            int i;
            allFigures.add(this.fEditUDFFigure.getUDFLeftConnectorFigure());
            allFigures.add(this.fEditUDFFigure.getUDFRightConnectorFigure());
            if (this.fEditUDFFigure.getInputfigures() != null) {
                for (i = 0; i < this.fEditUDFFigure.getInputfigures().size(); ++i) {
                    allFigures.add(this.fEditUDFFigure.getInputfigures().get(i));
                }
            }
            if (this.fEditUDFFigure.getInputfigures() != null) {
                for (i = 0; i < this.fEditUDFFigure.getOutputfigures().size(); ++i) {
                    allFigures.add(this.fEditUDFFigure.getOutputfigures().get(i));
                }
            }
        }
        return new FigureEnumerator(allFigures);
    }

    public FigureEnumeration figuresReverse() {
        int i;
        Vector<AbstractFigure> allFigures = new Vector<AbstractFigure>();
        allFigures.addAll(this.getFigures());
        allFigures.add(this.fEditUDFFigure.getUDFLeftConnectorFigure());
        allFigures.add(this.fEditUDFFigure.getUDFRightConnectorFigure());
        for (i = 0; i < this.fEditUDFFigure.getInputfigures().size(); ++i) {
            allFigures.add(this.fEditUDFFigure.getInputfigures().get(i));
        }
        for (i = 0; i < this.fEditUDFFigure.getOutputfigures().size(); ++i) {
            allFigures.add(this.fEditUDFFigure.getOutputfigures().get(i));
        }
        return new ReverseFigureEnumerator(allFigures);
    }

    public Rectangle displayBox() {
        Rectangle box = null;
        for (Object f : this.getFigures()) {
            if (f instanceof EditUDFFigure || f instanceof UDFCommentTextFigure) continue;
            if (box == null) {
                box = ((Figure)f).displayBox();
            }
            box.add(((Figure)f).displayBox());
        }
        if (box == null) {
            box = new Rectangle(60, 30);
        }
        return box;
    }

    private void addMacroFrame() {
        this.fEditUDFFigure = new EditUDFFigure((WiringDiagramUDF)this.getWiringDiagram(), new Point(50, 50));
        this.add(this.getUDFCommentTextFigure());
        this.add(this.fEditUDFFigure);
    }

    public WiringDiagram getWiringDiagram() {
        if (this.fWiringDiagram == null) {
            Hardware hardware = null;
            try {
                String hardwareString = "Logo7UDF";
                hardware = HardwareFactory.getInstance().createInstance(hardwareString);
            }
            catch (IOException ioe) {
                hardware = null;
            }
            this.setWiringDiagram(new WiringDiagramUDF(hardware));
        }
        return this.fWiringDiagram;
    }

    public void setWiringDiagram(WiringDiagram wd) {
        if (this.fEditUDFFigure != null) {
            this.fEditUDFFigure.setWiringDiagram((WiringDiagramUDF)wd);
        }
        super.setWiringDiagram(wd);
    }

    public Figure remove(Figure figure) {
        if (figure instanceof EditUDFFigure) {
            return null;
        }
        super.remove(figure);
        if (figure == this.fUDFCommentTextFigure) {
            ((WiringDiagramUDF)this.getWiringDiagram()).getUDFBlock().setComment(null);
            this.fUDFCommentTextFigure = null;
        }
        return figure;
    }

    public synchronized Figure addFigureAt(Figure figure, int index) {
        throw new UnsupportedOperationException();
    }

    public synchronized Figure add(Figure figure) {
        if (figure instanceof EditUDFFigure.MiniBlockFigure) {
            if (((EditUDFFigure.MiniBlockFigure)figure).getBlock() instanceof InputBlock) {
                ((WiringDiagramUDF)this.getWiringDiagram()).getInConnectorBlocks().add(((EditUDFFigure.MiniBlockFigure)figure).getBlock());
                this.fEditUDFFigure.getInputfigures().add((BlockFigure)figure);
            } else {
                ((WiringDiagramUDF)this.getWiringDiagram()).getOutConnectorBlocks().add(((EditUDFFigure.MiniBlockFigure)figure).getBlock());
                this.fEditUDFFigure.getOutputfigures().add((BlockFigure)figure);
            }
            this.fEditUDFFigure.add(figure);
            figure.setContainer(this.fEditUDFFigure);
        } else {
            if (this.getFigures().contains(figure)) {
                return figure;
            }
            this.getFigures().addElement(figure);
            figure.setContainer(this);
        }
        this.setModified(true);
        return figure;
    }

    public Figure findFigure(int x, int y) {
        if (this.fUDFCommentTextFigure != null && this.fUDFCommentTextFigure.containsPoint(x, y)) {
            return this.fUDFCommentTextFigure;
        }
        FigureEnumerator k = new FigureEnumerator(this.getFigures());
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure instanceof EditUDFFigure || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        if (this.fEditUDFFigure.containsPoint(x, y)) {
            Figure minifigure = this.fEditUDFFigure.getMiniFigureHavePoint(x, y);
            if (minifigure != null) {
                return minifigure;
            }
            if (this.fEditUDFFigure.havePointOnBorder(x, y)) {
                return this.fEditUDFFigure;
            }
        }
        return null;
    }

    public EditUDFFigure getEditUDFFigure() {
        return this.fEditUDFFigure;
    }

    public UDFCommentTextFigure getUDFCommentTextFigure() {
        if (this.fUDFCommentTextFigure == null) {
            this.fUDFCommentTextFigure = new UDFCommentTextFigure();
            this.fUDFCommentTextFigure.setText(((WiringDiagramUDF)this.getWiringDiagram()).getUDFBlock().getComment());
            this.fUDFCommentTextFigure.moveTo(new Point(this.fEditUDFFigure.getEditArea().x + this.fEditUDFFigure.getEditArea().width + 20, this.fEditUDFFigure.getEditArea().y));
            this.add(this.fUDFCommentTextFigure);
        }
        return this.fUDFCommentTextFigure;
    }

    public static boolean isUDF_IO(Block block) {
        if (block == null) {
            return false;
        }
        return block.getClass() == InputBlock.class || block.getClass() == AnalogInputBlock.class || block.getClass() == OutputBlock.class || block.getClass() == AnalogOutputBlock.class;
    }
}

